---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-フォームレイアウト（Bootstrap 4）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張が根拠付き）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_4_layout.html.twig` L1-324
- E-02: `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` L1-209
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行48（No.47のエントリ）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行120-121（No.47の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bootstrap_base_layoutをuseタグで読み込む | E-01 L1 | ○ |
| C-02 | money_widgetでinput-group-prepend/appendを使用 | E-01 L5-25 | ○ |
| C-03 | datetime/date/time_widgetでバリデーション時is-invalidを適用 | E-01 L27-49 | ○ |
| C-04 | dateinterval_widgetでcol-auto/form-inlineを使用 | E-01 L51-106 | ○ |
| C-05 | percent_widgetでinput-group-appendを使用 | E-01 L108-119 | ○ |
| C-06 | file_widgetでcustom-file構造を使用 | E-01 L121-135 | ○ |
| C-07 | form_widget_simpleでform-control/custom-file-input/form-control-rangeを振り分け | E-01 L137-152 | ○ |
| C-08 | widget_attributesでis-invalidクラスを条件付き適用 | E-01 L154-159 | ○ |
| C-09 | button_widgetでbtn-secondary btn、submit_widgetでbtn-primary | E-01 L161-169 | ○ |
| C-10 | checkbox_widgetで3パターン（form-check/custom-control/custom-switch）分岐 | E-01 L171-189 | ○ |
| C-11 | radio_widgetで2パターン（form-check/custom-control）分岐 | E-01 L191-204 | ○ |
| C-12 | form_labelでcol-form-label適用、compoundでlegend要素 | E-01 L225-246 | ○ |
| C-13 | form_rowでform-group適用、compoundでfieldset要素 | E-01 L281-298 | ○ |
| C-14 | form_errorsでinvalid-feedback/badge badge-danger表示 | E-01 L302-312 | ○ |
| C-15 | form_helpでform-text text-muted付きsmall要素 | E-01 L316-323 | ○ |
| C-16 | 関連機能：Form、Twig Bridge | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テンプレートファイルの全ブロックを確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Bootstrap 4固有のCSSクラス名が正確か確認（特にcustom-control系）
- [ ] is-invalidクラスの適用条件が正確か確認
- [ ] file_widgetのcustom-file構造が正確か確認
